/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build.xml;

import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.DrawingHistoryEntry;
import DE.siemens.ad.logo.model.DrawingProperties;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.model.hardware.Logo7UDF;
import DE.siemens.ad.logo.model.visitor.build.Visitor;
import DE.siemens.ad.logo.model.visitor.build.xml.StoreToXml;
import DE.siemens.ad.logo.util.ElementCodeBlock;
import DE.siemens.ad.logo.util.EncryptAndDecrypt;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.BlockIfcFigure;
import DE.siemens.ad.pdraw.figures.CommentTextFigure;
import DE.siemens.ad.pdraw.figures.CutConnectFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.InputCutConnectFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFCommentTextFigure;
import DE.siemens.ad.udf.WiringDiagramUDF;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.Paper;
import java.util.Iterator;
import org.dom4j.Element;

public class StoreUDFToXmlLogo7
extends Visitor
implements StoreToXml {
    protected Element fRootElement;
    protected LogoDrawingView fLogoDrawingView;

    public Element compile(LogoDrawingView view, Element parent) {
        this.fRootElement = parent;
        this.fLogoDrawingView = view;
        this.saveProperties(view, parent);
        WiringDiagram wd = ((LogoDrawing)view.drawing()).getWiringDiagram();
        wd.getHardware().getBlocksToXmlCompiler().compile(wd, this.fRootElement);
        Element figuresNode = parent.addElement("Figures");
        for (Object obj : ((LogoDrawing)view.drawing()).getFigures()) {
            this.acceptVisit((Figure)obj, figuresNode);
        }
        return null;
    }

    public Element visit(Figure figure, Element parent) {
        System.err.println("figures not saved");
        return this.saveFigureBasicInfo(figure, parent);
    }

    public Element visit(FixedElbowConnection figure, Element parent) {
        Element figureNode = this.saveFigureBasicInfo(figure, parent).addAttribute("type", "2");
        this.saveConnectorsInfo(true, figureNode, figure.startFigure());
        this.saveConnectorsInfo(false, figureNode, figure.endFigure());
        Element pointsNode = figureNode.addElement("Points");
        for (int count = 0; count < figure.pointCount(); ++count) {
            Point point = figure.pointAt(count);
            pointsNode.addElement("Point").addAttribute("x", String.valueOf(point.x)).addAttribute("y", String.valueOf(point.y));
        }
        return figureNode;
    }

    public Element visit(CutConnectFigure figure, Element parent) {
        String dir = figure instanceof InputCutConnectFigure ? "1" : "0";
        Element figureNode = this.saveFigureBasicInfo(figure, parent).addAttribute("type", "4").addAttribute("direction", dir).addAttribute("identifier", String.valueOf(figure.hashCode())).addAttribute("partner", String.valueOf(figure.getPartner().hashCode())).addAttribute("position", this.pointFormatter(figure.parentDisplayBox().getLocation()));
        return figureNode;
    }

    public Element visit(CommentTextFigure figure, Element parent) {
        String type = "3";
        if (figure instanceof UDFCommentTextFigure) {
            type = "5";
        }
        Element figureNode = this.saveFigureBasicInfo(figure, parent).addAttribute("type", type).addAttribute("position", this.pointFormatter(figure.getOriginPoint()));
        if (figure.getObservedFigure() != null && figure.getObservedFigure() instanceof BlockFigure) {
            Block block = ((BlockFigure)figure.getObservedFigure()).getBlock();
            if (((LogoDrawing)this.fLogoDrawingView.drawing()).getWiringDiagram().contains(block)) {
                figureNode.addAttribute("opcode", String.valueOf(block.getOpcode(((LogoDrawing)this.fLogoDrawingView.drawing()).getWiringDiagram().getHardware(), 0))).addAttribute("blockNumber", String.valueOf(block.getNumber()));
            }
            if (((BlockFigure)figure.getObservedFigure()).getCommentFigure() == figure) {
                figureNode.addAttribute("isBlockComment", String.valueOf(true));
            } else {
                figureNode.addAttribute("isBlockComment", String.valueOf(false));
            }
        }
        figureNode.addElement("Content").addAttribute("type", figure.getFont().getName()).addAttribute("style", String.valueOf(figure.getFont().getStyle())).addAttribute("size", String.valueOf(figure.getFont().getSize())).addAttribute("color", String.valueOf(((Color)figure.getAttribute("TextColor")).getRGB())).addText(figure.getText());
        if (figure.isWrapText()) {
            figureNode.addElement("WrapText").addAttribute("width", String.valueOf(figure.textExtent().width)).addAttribute("height", String.valueOf(figure.textExtent().height));
        }
        return figureNode;
    }

    public Element visit(BlockFigure figure, Element parent) {
        Block ownerBlock = figure.getBlock();
        Element figureNode = this.saveFigureBasicInfo(figure, parent).addAttribute("type", "1").addAttribute("opcode", String.valueOf(ownerBlock.getOpcode(ownerBlock.getHardware(), 0))).addAttribute("blockNumber", String.valueOf(ownerBlock.getNumber())).addAttribute("position", this.pointFormatter(figure.selectionBox().getLocation()));
        return figureNode;
    }

    public Element visit(EditUDFFigure.MiniBlockFigure figure, Element parent) {
        Block ownerBlock = figure.getBlock();
        Element figureNode = this.saveFigureBasicInfo(figure, parent).addAttribute("type", "1").addAttribute("opcode", String.valueOf(ownerBlock.getOpcode(ownerBlock.getHardware(), 0))).addAttribute("blockNumber", String.valueOf(ownerBlock.getNumber())).addAttribute("position", this.pointFormatter(figure.selectionBox().getLocation()));
        return figureNode;
    }

    public Element visit(EditUDFFigure figure, Element parent) {
        Element figureNode = this.saveFigureBasicInfo(figure, parent).addAttribute("type", "0").addAttribute("area", this.rectangleFormatter(figure.getEditArea()));
        Element inGroup = figureNode.addElement("InGroup");
        for (BlockFigure minBlockFigure : figure.getInputfigures()) {
            this.acceptVisit(minBlockFigure, inGroup);
        }
        Element outGroup = figureNode.addElement("OutGroup");
        for (BlockFigure minBlockFigure : figure.getOutputfigures()) {
            this.acceptVisit(minBlockFigure, outGroup);
        }
        return figureNode;
    }

    protected Element acceptVisit(Object parameter1, Object parameter2) {
        ElementCodeBlock c = new ElementCodeBlock(this, "visit");
        c.addParameter(parameter1);
        c.addParameter(parameter2);
        Element returnValue = null;
        try {
            returnValue = (Element)c.execMethod();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    protected Element saveFigureBasicInfo(Figure figure, Element parent) {
        return parent.addElement("Figure");
    }

    protected Element saveProperties(LogoDrawingView view, Element udfBlockNode) {
        LogoDrawing drawing = (LogoDrawing)view.drawing();
        DrawingProperties model = drawing.getWiringDiagram().getDrawingProperties();
        Element propertiesNode = udfBlockNode.addElement("Properties");
        propertiesNode.addElement("Creator").setText(model.getCreator());
        propertiesNode.addElement("Projectname").setText(model.getProjectname());
        propertiesNode.addElement("Installationname").setText(model.getInstallationname());
        propertiesNode.addElement("Customer").setText(model.getCustomer());
        propertiesNode.addElement("Diagramno").setText(model.getDiagramnr());
        propertiesNode.addElement("Checked").setText(model.getChecked());
        propertiesNode.addElement("Company").setText(model.getCompany());
        propertiesNode.addElement("Version").setText(model.getVersion());
        propertiesNode.addElement("Show").setText(String.valueOf(model.getShowDialogAtNewFile()));
        propertiesNode.addElement("Comments").setText(model.getComment());
        propertiesNode.addElement("Horizontal").setText(String.valueOf(model.getPagesHorizontal()));
        propertiesNode.addElement("Vertical").setText(String.valueOf(model.getPagesVertical()));
        Element history = propertiesNode.addElement("History");
        Iterator historyIT = drawing.getWiringDiagram().getDrawingProperties().getDrawingHistory().iterator();
        Element displayed = history.addElement("DisplayedHistory");
        DrawingHistoryEntry dhe2 = null;
        while (historyIT.hasNext()) {
            dhe2 = (DrawingHistoryEntry)historyIT.next();
            displayed.addElement("Date").setText(String.valueOf(dhe2.getChangeDate().getTime()));
            displayed.addElement("User").setText(dhe2.getUser());
            displayed.addElement("Version").setText(dhe2.getSoftwareVersion().toString());
            displayed.addElement("Comments").setText(dhe2.getChangeComment() == null ? "" : dhe2.getChangeComment());
            displayed.addElement("Saved").setText(String.valueOf(dhe2.isSaved()));
        }
        Element deleted = history.addElement("DeletedHistory");
        for (DrawingHistoryEntry dhe2 : drawing.getWiringDiagram().getDrawingProperties().getDeletedHistory()) {
            deleted.addElement("Date").setText(String.valueOf(dhe2.getChangeDate().getTime()));
            deleted.addElement("User").setText(dhe2.getUser());
            deleted.addElement("Version").setText(dhe2.getSoftwareVersion().toString());
            deleted.addElement("Comments").setText(dhe2.getChangeComment() == null ? "" : dhe2.getChangeComment());
            displayed.addElement("Deleted").setText(String.valueOf(dhe2.isDeleted()));
        }
        propertiesNode.addElement("Zoom").setText(String.valueOf(view.getZoomManager().getZoom()));
        Paper paper = drawing.getPageFormat().getPaper();
        Element pageFormatNode = propertiesNode.addElement("PageFormat");
        Element marginNode = pageFormatNode.addElement("Margin");
        marginNode.addElement("Left").setText(String.valueOf(paper.getImageableX()));
        marginNode.addElement("Top").setText(String.valueOf(paper.getImageableY()));
        Element imagesizeNode = pageFormatNode.addElement("Imagesize");
        imagesizeNode.addElement("Height").setText(String.valueOf(paper.getImageableHeight()));
        imagesizeNode.addElement("Width").setText(String.valueOf(paper.getImageableWidth()));
        Element paperNode = pageFormatNode.addElement("Paper");
        paperNode.addElement("Height").setText(String.valueOf(paper.getHeight()));
        paperNode.addElement("Width").setText(String.valueOf(paper.getWidth()));
        pageFormatNode.addElement("Orientation").setText(String.valueOf(drawing.getPageFormat().getOrientation()));
        UDFBlock udfBlock = ((WiringDiagramUDF)drawing.getWiringDiagram()).getUDFBlock();
        int checksum = ((Logo7UDF)((WiringDiagramUDF)drawing.getWiringDiagram()).getHardware()).getChecksum(drawing.getWiringDiagram());
        StringBuffer cipherBf = new StringBuffer("");
        cipherBf.append(Util.addLeadingZeros(String.valueOf(String.valueOf(checksum).length()), 2));
        cipherBf.append(String.valueOf(checksum));
        cipherBf.append(udfBlock.getPassword());
        String cipher = new String("");
        try {
            cipher = EncryptAndDecrypt.encrypt(cipherBf.toString(), String.valueOf(checksum));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        propertiesNode.addElement("Password").setText(cipher);
        return propertiesNode;
    }

    protected String pointFormatter(Point point) {
        return point.x + "," + point.y;
    }

    protected String rectangleFormatter(Rectangle r) {
        return r.getLocation().x + "," + r.getLocation().y + "," + r.getWidth() + "," + r.getHeight();
    }

    protected void saveConnectorsInfo(boolean start, Element blockFigureNode, Figure conorFigure) {
        Block block = null;
        String connType = "-1";
        Element endConorElement = blockFigureNode.addElement("Connector");
        if (conorFigure instanceof BlockIfcFigure) {
            block = ((BlockFigure)conorFigure.container()).getBlock();
            connType = "0";
            endConorElement.addAttribute("index", String.valueOf(this.getConnectionIndex((BlockIfcFigure)conorFigure))).addAttribute("opcode", String.valueOf(block.getOpcode(block.getHardware(), 0))).addAttribute("blockNumber", String.valueOf(block.getNumber()));
        } else if (conorFigure instanceof CutConnectFigure) {
            connType = "1";
            endConorElement.addAttribute("identifier", String.valueOf(conorFigure.hashCode())).addAttribute("partner", String.valueOf(((CutConnectFigure)conorFigure).getPartner().hashCode()));
        } else {
            System.err.println(conorFigure);
        }
        String direction = start ? "0" : "1";
        endConorElement.addAttribute("direction", direction).addAttribute("type", connType);
    }

    private int getConnectionIndex(BlockIfcFigure conorFigure) {
        if (conorFigure.getBlockConnector().getOwner().getClass() == DeputyBlock.class) {
            DeputyBlock deputy = (DeputyBlock)conorFigure.getBlockConnector().getOwner();
            if (conorFigure.getBlockConnector().getInputOutputType() == 0) {
                return deputy.getParent().getIndexOfInputDeputy(deputy);
            }
            return deputy.getParent().getIndexOfOutputDeputy(deputy);
        }
        return conorFigure.getBlockConnector().getConnectorPosition();
    }
}

